package main;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Color;

import net.miginfocom.swing.MigLayout;
import util.Utility;

import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JButton;
import javax.swing.JTextArea;
import java.awt.Dimension;
import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;
import javax.swing.filechooser.FileNameExtensionFilter;

import music.Album;
import music.Performer;
import music.Song;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.awt.event.ActionEvent;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.awt.event.ItemEvent;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class GUI {

	private JFrame frmSgtPepper;
	private JPanel northPanel;
	private JPanel westPanel;
	private JPanel eastPanel;
	private JPanel southPanel;
	private JPanel centralPanel;
	private JLabel lblAlbum;
	private JLabel lblTitle;
	private JTextField titleTextField;
	private JLabel lblPerformer;
	private JTextField performerTextField;
	private JLabel lblSongs;
	private JComboBox songsComboBox;
	private JLabel lblReleaseDate;
	private JLabel lblSpecificReleaseDate;
	private JLabel lblCredits;
	private JTextArea creditsTextArea;
	private JButton btnSave;
	private JSplitPane splitPane;
	private JScrollPane leftScrollPane;
	private JScrollPane rightScrollPane;
	private JTextArea lyricsTextArea;
	private JLabel lblPicture;
	private JRadioButton rdbtnBasic;
	private JRadioButton rdbtnStandard;
	private JRadioButton rdbtnAll;
	private JLabel lblDetails;
	private final ButtonGroup buttonGroup = new ButtonGroup();
	
	private Album album = null;
	private LinkedList<Song> songs = new LinkedList<Song>();
	private Song song;
	private NewSongDialog newSongDialog;
	
	private JButton btnTest;
	private JMenuBar menuBar;
	private JMenu mnFile;
	private JMenu mnEdit;
	private JMenu mnHelp;
	private JMenuItem mntmNewSong;
	private JMenuItem mntmOpen;
	private JMenuItem mntmNewalbum;
	private JMenuItem mntmSave;
	private JMenuItem mntmSaveas;
	private JMenuItem mntmExit;
	private JSeparator separator;
	private JSeparator separator_1;
	private JSeparator separator_2;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					GUI window = new GUI();
					window.frmSgtPepper.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public GUI() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmSgtPepper = new JFrame();
		createResourcesDir();
		frmSgtPepper.setTitle("Sgt. Pepper");
		frmSgtPepper.setBounds(100, 100, 668, 494);
		frmSgtPepper.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmSgtPepper.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmSgtPepper.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmSgtPepper.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmSgtPepper.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmSgtPepper.getContentPane().add(getCentralPanel(), BorderLayout.CENTER);
		frmSgtPepper.setJMenuBar(getMenuBar());
		
		album = Album.deserialize(Utility.getSubdir("resources") + "\\sgt.serialized");
		populateSongsComboBox();
    	SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
    	GregorianCalendar releaseDate = new GregorianCalendar(1967, 5, 1);
    	lblSpecificReleaseDate.setForeground(Color.BLUE);
    	lblSpecificReleaseDate.setText(df.format(releaseDate.getTime()));
//        System.out.println("Album: " + title + " (" + year + ")");
//        System.out.println("Release date: " + df.format(releaseDate.getTime()));
		creditsTextArea.setText(album.getCredits().get(0));

	}
	
	private void createResourcesDir() {
//		System.out.println(Utility.getSubdir("resources"));
		Utility.getSubdir("resources");
	}
	
	private void populateSongsComboBox() {
		for (int i = 0; i < album.getSongs().length; i++) {
			songsComboBox.addItem(album.getSongs()[i].getTitle());
			songs.add(album.getSongs()[i]);
		}
//		
//		songsComboBox.addItem("Sgt. Pepper's Lonely Hearts Club Band");
//		songsComboBox.addItem("With a Little Help from My Friends");
//		songsComboBox.addItem("Lucy in the Sky with Diamonds");
	}

	private Album getAlbum() {
		if (album == null) {
			album = new Album();
		}
		album.setTitle(titleTextField.getText());
		Performer p = new Performer();
		p.setName(performerTextField.getText());
		album.setPerformer(p);
		album.setSongs(songs.toArray(new Song[0]));
		ArrayList<String> credits = new ArrayList<String>();
		credits.add(creditsTextArea.getText());
		album.setCredits(credits);
		String[] date = (lblSpecificReleaseDate.getText()).split("\\.");
		GregorianCalendar releaseDate = new GregorianCalendar(
				Integer.parseInt(date[2]), 
				(Integer.parseInt(date[1]) - 1), 
				Integer.parseInt(date[0]));
		album.setReleaseDate(releaseDate);
		return album;
	}
	
	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			northPanel.add(getLblAlbum());
		}
		return northPanel;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setLayout(new MigLayout("", "[grow]", "[][][][][][][grow][]"));
			westPanel.add(getLblTitle(), "cell 0 0");
			westPanel.add(getTitleTextField(), "cell 0 1,growx");
			westPanel.add(getLblPerformer(), "cell 0 2");
			westPanel.add(getPerformerTextField(), "cell 0 3,growx");
			westPanel.add(getLblSongs(), "cell 0 4");
			westPanel.add(getSongsComboBox(), "cell 0 5,growx");
			westPanel.add(getBtnTest(), "cell 0 7,growx");
		}
		return westPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
			eastPanel.setPreferredSize(new Dimension(130, 10));
			eastPanel.setLayout(new MigLayout("", "[grow]", "[][][][grow][]"));
			eastPanel.add(getLblReleaseDate(), "cell 0 0");
			eastPanel.add(getLblSpecificReleaseDate(), "cell 0 1");
			eastPanel.add(getLblCredits(), "cell 0 2");
			eastPanel.add(getCreditsTextArea(), "cell 0 3,grow");
			eastPanel.add(getBtnSave(), "cell 0 4,alignx right");
		}
		return eastPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setLayout(new MigLayout("", "[grow][][][][grow]", "[][]"));
			southPanel.add(getLblDetails(), "cell 1 0 3 1,alignx center");
			southPanel.add(getRdbtnBasic(), "cell 1 1");
			southPanel.add(getRdbtnStandard(), "cell 2 1");
			southPanel.add(getRdbtnAll(), "cell 3 1");
		}
		return southPanel;
	}
	private JPanel getCentralPanel() {
		if (centralPanel == null) {
			centralPanel = new JPanel();
			centralPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
			centralPanel.add(getSplitPane(), "cell 0 0,grow");
		}
		return centralPanel;
	}
	private JLabel getLblAlbum() {
		if (lblAlbum == null) {
			lblAlbum = new JLabel("Album");
		}
		return lblAlbum;
	}
	private JLabel getLblTitle() {
		if (lblTitle == null) {
			lblTitle = new JLabel("Title");
		}
		return lblTitle;
	}
	private JTextField getTitleTextField() {
		if (titleTextField == null) {
			titleTextField = new JTextField();
			titleTextField.setMaximumSize(new Dimension(100, 2147483647));
			titleTextField.setPreferredSize(new Dimension(100, 20));
			titleTextField.setColumns(10);
		}
		return titleTextField;
	}
	private JLabel getLblPerformer() {
		if (lblPerformer == null) {
			lblPerformer = new JLabel("Performer");
		}
		return lblPerformer;
	}
	private JTextField getPerformerTextField() {
		if (performerTextField == null) {
			performerTextField = new JTextField();
			performerTextField.setMaximumSize(new Dimension(100, 2147483647));
			performerTextField.setPreferredSize(new Dimension(100, 20));
			performerTextField.setColumns(10);
		}
		return performerTextField;
	}
	private JLabel getLblSongs() {
		if (lblSongs == null) {
			lblSongs = new JLabel("Songs");
		}
		return lblSongs;
	}
	private JComboBox getSongsComboBox() {
		if (songsComboBox == null) {
			songsComboBox = new JComboBox();
			songsComboBox.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent arg0) {
					if (arg0.getStateChange() == ItemEvent.SELECTED) {
						lyricsTextArea.setForeground(Color.BLACK);
						String title = (String) songsComboBox.getSelectedItem();
						for (int i = 0; i < album.getSongs().length; i++) {
							if (album.getSongs()[i].getTitle().equals(title)) {
								lyricsTextArea.setText(album.getSongs()[i].getLyrics());
								break;
							}
						}
//						System.out.println("Selected");
					}
				}
			});
			songsComboBox.setPreferredSize(new Dimension(100, 20));
			songsComboBox.setMaximumSize(new Dimension(100, 32767));
		}
		return songsComboBox;
	}
	private JLabel getLblReleaseDate() {
		if (lblReleaseDate == null) {
			lblReleaseDate = new JLabel("Release date");
		}
		return lblReleaseDate;
	}
	private JLabel getLblSpecificReleaseDate() {
		if (lblSpecificReleaseDate == null) {
			lblSpecificReleaseDate = new JLabel("");
		}
		return lblSpecificReleaseDate;
	}
	private JLabel getLblCredits() {
		if (lblCredits == null) {
			lblCredits = new JLabel("Credits");
		}
		return lblCredits;
	}
	private JTextArea getCreditsTextArea() {
		if (creditsTextArea == null) {
			creditsTextArea = new JTextArea();
		}
		return creditsTextArea;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
			btnSave.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
				    JFileChooser chooser = new JFileChooser();
				    FileNameExtensionFilter filter = new FileNameExtensionFilter(
				        "Serialized album files", "serialized", "serial");
				    chooser.setFileFilter(filter);
				    chooser.setCurrentDirectory(new File(Utility.getProjectDir()));
				    int returnVal = chooser.showSaveDialog(frmSgtPepper);
				    if(returnVal == JFileChooser.APPROVE_OPTION) {
//				    	getAlbum().serialize(Utility.getSubdir("resources") + "\\sgt.serialized");
				    	album = getAlbum();
				    	album.serialize(Utility.getSubdir("resources") + "\\" + chooser.getSelectedFile().getName());
//				       System.out.println("You chose to open this file: " +
//				            chooser.getSelectedFile().getName());
				    }

					JOptionPane.showMessageDialog(frmSgtPepper,
						    "Album saved.");
				}
			});
		}
		return btnSave;
	}
	private JSplitPane getSplitPane() {
		if (splitPane == null) {
			splitPane = new JSplitPane();
			splitPane.setLeftComponent(getLeftScrollPane());
			splitPane.setRightComponent(getRightScrollPane());
			splitPane.setDividerLocation(130);
			splitPane.setOneTouchExpandable(true);
		}
		return splitPane;
	}
	private JScrollPane getLeftScrollPane() {
		if (leftScrollPane == null) {
			leftScrollPane = new JScrollPane();
			leftScrollPane.setViewportView(getLyricsTextArea());
		}
		return leftScrollPane;
	}
	private JScrollPane getRightScrollPane() {
		if (rightScrollPane == null) {
			rightScrollPane = new JScrollPane();
			rightScrollPane.setViewportView(getLblPicture());
		}
		return rightScrollPane;
	}
	private JTextArea getLyricsTextArea() {
		if (lyricsTextArea == null) {
			lyricsTextArea = new JTextArea();
			lyricsTextArea.setLineWrap(true);
			lyricsTextArea.setWrapStyleWord(true);;
		}
		return lyricsTextArea;
	}
	private JLabel getLblPicture() {
		if (lblPicture == null) {
			lblPicture = new JLabel("");
			lblPicture.setHorizontalAlignment(SwingConstants.CENTER);
//			lblPicture.setIcon(new ImageIcon("C:\\Users\\student1\\Desktop\\Eclipse workspace\\Sgt. Pepper\\resources\\sgt.jpg"));
			lblPicture.setIcon(new ImageIcon(Utility.getSubdir("resources") + "\\sgt.jpg"));
		}
		return lblPicture;
	}
    private JRadioButton getRdbtnBasic() {
        if (rdbtnBasic == null) {
            rdbtnBasic = new JRadioButton("Basic");
            rdbtnBasic.addItemListener(new ItemListener() {
                public void itemStateChanged(ItemEvent arg0) {
                    getCentralPanel().setVisible(false);
                    getLblReleaseDate().setVisible(false);
                    getLblSpecificReleaseDate().setVisible(false);
                    getLblCredits().setVisible(false);
                    getCreditsTextArea().setVisible(false);
                    getBtnSave().setVisible(false);
                }
            });
            buttonGroup.add(rdbtnBasic);
        }
        return rdbtnBasic;
    }
    private JRadioButton getRdbtnStandard() {
        if (rdbtnStandard == null) {
            rdbtnStandard = new JRadioButton("Standard");
            rdbtnStandard.addItemListener(new ItemListener() {
                public void itemStateChanged(ItemEvent arg0) {
                    getCentralPanel().setVisible(true);
                    getLblReleaseDate().setVisible(false);
                    getLblSpecificReleaseDate().setVisible(false);
                    getLblCredits().setVisible(false);
                    getCreditsTextArea().setVisible(false);
                    getBtnSave().setVisible(false);
                }
            });
            buttonGroup.add(rdbtnStandard);
            rdbtnStandard.setSelected(true);
        }
        return rdbtnStandard;
    }
    private JRadioButton getRdbtnAll() {
        if (rdbtnAll == null) {
            rdbtnAll = new JRadioButton("All");
            rdbtnAll.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent arg0) {
                    getCentralPanel().setVisible(true);
                    getLblReleaseDate().setVisible(true);
                    getLblSpecificReleaseDate().setVisible(true);
                    getLblCredits().setVisible(true);
                    getCreditsTextArea().setVisible(true);
                    getBtnSave().setVisible(true);
                }
            });
            buttonGroup.add(rdbtnAll);
        }
        return rdbtnAll;
    }
	private JLabel getLblDetails() {
		if (lblDetails == null) {
			lblDetails = new JLabel("Details");
		}
		return lblDetails;
	}
	private JButton getBtnTest() {
		if (btnTest == null) {
			btnTest = new JButton("Test");
			btnTest.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					Song s = new Song();
					s.setTitle((String) songsComboBox.getSelectedItem());
					s.setLyrics(lyricsTextArea.getText());
					songs.add(s);
//					Album a = Album.deserialize(Utility.getSubdir("resources") + "\\sgt.serialized");
//					System.out.println(a);
//					populateSongsComboBox();
				}
			});
		}
		return btnTest;
	}
	private JMenuBar getMenuBar() {
		if (menuBar == null) {
			menuBar = new JMenuBar();
			menuBar.add(getMnFile());
			menuBar.add(getMnEdit());
			menuBar.add(getMnHelp());
		}
		return menuBar;
	}
	private JMenu getMnFile() {
		if (mnFile == null) {
			mnFile = new JMenu("File");
			mnFile.add(getMntmNewSong());
			mnFile.add(getMntmNewalbum());
			mnFile.add(getSeparator());
			mnFile.add(getMntmOpen());
			mnFile.add(getSeparator_1());
			mnFile.add(getMntmSave());
			mnFile.add(getMntmSaveas());
			mnFile.add(getSeparator_2());
			mnFile.add(getMntmExit());
		}
		return mnFile;
	}
	private JMenu getMnEdit() {
		if (mnEdit == null) {
			mnEdit = new JMenu("Edit");
		}
		return mnEdit;
	}
	private JMenu getMnHelp() {
		if (mnHelp == null) {
			mnHelp = new JMenu("Help");
		}
		return mnHelp;
	}
	private JMenuItem getMntmNewSong() {
		if (mntmNewSong == null) {
			mntmNewSong = new JMenuItem("NewSong...");
			mntmNewSong.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					newSongDialog = new NewSongDialog(frmSgtPepper, true);
					song = newSongDialog.showDialog();
					if (song != null) {
						if (isNewSongOK(song)) {
							songs.add(song);
							songsComboBox.addItem(song.getTitle());
							songsComboBox.setSelectedIndex(songsComboBox.getItemCount() - 1);
							lyricsTextArea.setText(song.getLyrics());
						} else {
							lyricsTextArea.setForeground(Color.RED);
							lyricsTextArea.setText("Something went wrong...");
							songsComboBox.setSelectedIndex(-1);
						}
//						lyricsTextArea.setForeground(Color.BLACK);
					}
				}
			});
		}
		return mntmNewSong;
	}
	private JMenuItem getMntmOpen() {
		if (mntmOpen == null) {
			mntmOpen = new JMenuItem("Open...");
		}
		return mntmOpen;
	}
	private JMenuItem getMntmNewalbum() {
		if (mntmNewalbum == null) {
			mntmNewalbum = new JMenuItem("NewAlbum...");
		}
		return mntmNewalbum;
	}
	private JMenuItem getMntmSave() {
		if (mntmSave == null) {
			mntmSave = new JMenuItem("Save");
		}
		return mntmSave;
	}
	private JMenuItem getMntmSaveas() {
		if (mntmSaveas == null) {
			mntmSaveas = new JMenuItem("SaveAs...");
		}
		return mntmSaveas;
	}
	private JMenuItem getMntmExit() {
		if (mntmExit == null) {
			mntmExit = new JMenuItem("Exit");
			mntmExit.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					System.exit(0);
				}
			});
		}
		return mntmExit;
	}
	private JSeparator getSeparator() {
		if (separator == null) {
			separator = new JSeparator();
		}
		return separator;
	}
	private JSeparator getSeparator_1() {
		if (separator_1 == null) {
			separator_1 = new JSeparator();
		}
		return separator_1;
	}
	private JSeparator getSeparator_2() {
		if (separator_2 == null) {
			separator_2 = new JSeparator();
		}
		return separator_2;
	}
	private boolean isNewSongOK(Song s) {
		if (((!s.getTitle().equals(null)) && (!s.getTitle().equals(""))) &&
			((!s.getLyrics().equals(null)) && (!s.getLyrics().equals(""))) &&
			((s.getTime() != 0))) {
			return true;
		}
		return false;
	}
}
